/* 
 * nolocks.c
 *
 * Створює тимчасовий файл і дочірній процес, після чого батьківський
 * процес записує в тимчасовий файл повідомлення, а дочірній їх читає
 * й виводить. Запобігання змагань між батьківським і дочірнім процесами
 * не виконується.
 *
 */

#include <assert.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#define BUFSIZE         100

#define STRING1         "Ті, хто виконає сьогодні завдання,"
#define STRING2         "отримають п'ятірки."
#define STRING3         "А ті, хто не виконає - "
#define STRING4         "отримають ДВІЙКИ!"

#define MAX_DELAY       3                       /* Максимальна затримка */
#define GET_DELAY       random() % MAX_DELAY    /* Обчислення випадкової
                                                   затримки */

#define SIGRDEN         34                      /* Сигнал, яким письменник
                                                   запускає читача */

sig_atomic_t read_en = 0;                       /* Прапорець запуску
                                                   читача */


/* обробник сигналу SIGRDEN */
void sigrden_hndlr(int signo)
{
        read_en++;
}

int main()
{
        char buf[BUFSIZE];
        int wfd, rfd;
        char temp_filename[] = "/tmp/flocks-example.XXXXXX";
        struct sigaction act;
        pid_t child_pid;
        int rval;

        /* Створює тимчасовий файл (замість XXXXXX його ім'я буде мати
           унікальний набір символів). Дескриптор wfd буде мати права на
           читання й запис. */
        wfd = mkstemp(temp_filename);
        if (wfd < 0) {
                perror("mkstemp");
                exit(EXIT_FAILURE);
        }
        /* Додатково відкриває тимчасовий файл для читання. */
        rfd = open(temp_filename, O_RDONLY);
        if (rfd < 0) {
                perror("open");
                exit(EXIT_FAILURE);
        }
        /* Видаляє з файлової системи посилання на тимчасовий файл. */
        if (unlink(temp_filename) != 0)
                perror("unlink");

        /* Реєструє обробник сигналу SIGRDEN. */
        act.sa_handler = sigrden_hndlr;
        sigemptyset(&act.sa_mask);
        act.sa_flags = 0;
        if (sigaction(SIGRDEN, &act, NULL) != 0) {
                perror("sigaction");
                exit(EXIT_FAILURE);
        }

        /* Створює дочірній процес. */    
        child_pid = fork();
        switch (child_pid) {
        case -1:
                perror("fork");
                exit(EXIT_FAILURE);
        case 0: 
        {
                /* Дочірній процес (читач).
                   Чекає, доки письменник його запустить. */
                while (read_en == 0)
                        pause();
                while (1) {
                        /* Установлює покажчик поточної позиції в початок
                           файлу. */
                        rval = lseek(rfd, 0, SEEK_SET); 
                        assert(rval == 0);
                        /* Читає 1-й рядок. */
                        if (read(rfd, buf, BUFSIZE) < 0) {
                                perror("read");
                                exit(EXIT_FAILURE);
                        }
                        /* Виводить 1-й рядок. */
                        printf("%s\n", buf);
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                        /* Читає 2-й рядок. */
                        if (read(rfd, buf, BUFSIZE) < 0) {
                                perror("read");
                                exit(EXIT_FAILURE);
                        }
                        /* Виводить 2-й рядок. */
                        printf("%s\n", buf);
                        printf("\n");
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                }
        }
        default:
                /* Батьківський процес (письменник) */
                while (1) {
                        /* Установлює покажчик поточної позиції в
                           початок файлу. */
                        rval = lseek(wfd, 0, SEEK_SET);
                        assert(rval == 0); 
                        /* Копіює 1-й рядок в буфер. */
                        strncpy(buf, STRING1, BUFSIZE);
                        /* Записує 1-й рядок у файл. */
                        if (write(wfd, buf, BUFSIZE) < 0) {
                                perror("write");
                                exit(EXIT_FAILURE);
                        }
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                        /* Копіює 2-й рядок у буфер. */
                        strncpy(buf, STRING2, BUFSIZE);
                        /* Записує 2-й рядок у файл. */
                        if (write(wfd, buf, BUFSIZE) < 0) {
                                perror("write");
                                exit(EXIT_FAILURE);
                        }
                        /* Якщо читач ще не запущений, відправляє йому
                           сигнал SIGRDEN. */
                        if (read_en == 0) {
                                rval = kill(child_pid, SIGRDEN);
                                assert(rval == 0);
                                read_en++;
                        }
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                        /* Установлює покажчик поточної позиції в початок
                           файлу. */
                        rval = lseek(wfd, 0, SEEK_SET);
                        /* Копіює 3-й рядок у буфер. */
                        strncpy(buf, STRING3, BUFSIZE);
                        /* Записує 3-й рядок у файл. */
                        if (write(wfd, buf, BUFSIZE) < 0) {
                                perror("write");
                                exit(EXIT_FAILURE);
                        }
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                        /* Копіює 4-й рядок у буфер. */
                        strncpy(buf, STRING4, BUFSIZE);
                        /* Записує 4-й рядок у файл. */
                        if (write(wfd, buf, BUFSIZE) < 0) {
                                perror("write");
                                exit(EXIT_FAILURE);
                        }
                        /* Засинає на випадковий інтервал часу. */
                        sleep(GET_DELAY);
                }
        }
}
